function Vergeer_etal_2021_replication_plot(h_fig, metric_data, length_num_s, sigma2, y_lim, y_label)

plot_font_size = 18;
plot_letter = {'(a)', '(b)', '(c)'};
fig_ratio = [2 2];
ax_ratio = 1.2;


fig_position = get(h_fig, 'Position');
fig_position_new = [200, 200, fig_position(4)*fig_ratio(1), fig_position(4)*fig_ratio(2)];
set(h_fig, 'Position',fig_position_new);  

if isempty(y_lim)
    set_y_lim = false;
else
    set_y_lim = true;
end

for I_row = 1:length_num_s
    h_ax(I_row) = subplot(length_num_s,1,I_row);
    
    if I_row == length_num_s
        labels = arrayfun(@num2str, sigma2, 'UniformOutput', 0);
    else
        labels = [];
    end
    
    plot_data = metric_data(:,:,I_row);
    if I_row == 1
        [~,~,~,~,~,width] = violin(plot_data, 'xlabel',labels, 'facecolor',[0.9 0.9 0.9], 'mc',[], 'plotlegend',false, 'same_area',true);
    else
        violin(plot_data, 'xlabel',labels, 'facecolor',[0.9 0.9 0.9], 'mc',[], 'plotlegend',false, 'same_area',true, 'width',width);
    end
    
    if I_row ~= length_num_s
        set(h_ax(I_row), 'xTick',[]);
    else
        xlabel('\sigma^{2}', 'FontSize',plot_font_size);
    end
    
    if set_y_lim
        ylim(y_lim);
    end
    ylabel(y_label)
    
    ax_position = get(h_ax(I_row),'Position'); 
    ax_position_new = ax_position;
    ax_position_new(4) = ax_position(4)*ax_ratio;
    set(h_ax(I_row), 'Position',ax_position_new);
    
    text(0.025, 0.9, plot_letter{I_row}, 'FontSize',plot_font_size, 'Units','Normalized');
end